/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.simibubi.create.content.contraptions.components.deployer.DeployerFakePlayer;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationBlock;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StationBlock.class}, remap=false)
public abstract class MixinStationBlock {
    @Inject(method={"use"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true, remap=true)
    private void deployersAssemble(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit, CallbackInfoReturnable<InteractionResult> cir) {
        if (!pLevel.f_46443_ && pPlayer instanceof DeployerFakePlayer) {
            DeployerFakePlayer deployerFakePlayer = (DeployerFakePlayer)pPlayer;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof StationTileEntity) {
                StationTileEntity stationTe = (StationTileEntity)blockEntity;
                cir.setReturnValue((Object)InteractionResult.CONSUME);
                GlobalStation station = stationTe.getStation();
                boolean isAssemblyMode = (Boolean)pState.m_61143_((Property)StationBlock.ASSEMBLING);
                if (station != null && station.getPresentTrain() == null) {
                    if (stationTe.isAssembling() || stationTe.tryEnterAssemblyMode()) {
                        stationTe.assemble(deployerFakePlayer.m_142081_());
                        cir.setReturnValue((Object)InteractionResult.SUCCESS);
                        if (isAssemblyMode) {
                            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(false)), 3);
                            stationTe.refreshBlockState();
                        }
                    }
                    return;
                }
                BlockState newState = null;
                if (!isAssemblyMode) {
                    newState = (BlockState)pState.m_61124_((Property)StationBlock.ASSEMBLING, (Comparable)Boolean.valueOf(true));
                }
                if (this.disassembleAndEnterMode((ServerPlayer)deployerFakePlayer, stationTe)) {
                    if (newState != null) {
                        pLevel.m_7731_(pPos, newState, 3);
                        stationTe.refreshBlockState();
                        stationTe.refreshAssemblyInfo();
                    }
                    cir.setReturnValue((Object)InteractionResult.SUCCESS);
                }
            }
        }
    }

    private boolean disassembleAndEnterMode(ServerPlayer sender, StationTileEntity te) {
        GlobalStation station = te.getStation();
        if (station != null) {
            ItemStack schedule;
            Train train = station.getPresentTrain();
            BlockPos trackPosition = te.edgePoint.getGlobalPosition();
            ItemStack itemStack = schedule = train == null ? ItemStack.f_41583_ : train.runtime.returnSchedule();
            if (train != null && !train.disassemble(te.getAssemblyDirection(), trackPosition.m_7494_())) {
                return false;
            }
            this.dropSchedule(sender, te, schedule);
        }
        return te.tryEnterAssemblyMode();
    }

    private void dropSchedule(ServerPlayer sender, StationTileEntity te, ItemStack schedule) {
        if (schedule.m_41619_()) {
            return;
        }
        if (sender.m_21205_().m_41619_()) {
            sender.m_150109_().m_150079_(schedule);
            return;
        }
        Vec3 v = VecHelper.getCenterOf((Vec3i)te.m_58899_());
        ItemEntity itemEntity = new ItemEntity(te.m_58904_(), v.f_82479_, v.f_82480_, v.f_82481_, schedule);
        itemEntity.m_20256_(Vec3.f_82478_);
        te.m_58904_().m_7967_((Entity)itemEntity);
    }
}

